<?php
session_start();
require_once 'config.php';

$page_title = 'Check Email Status';

$conn = getDBConnection();

// Check all emails and their statuses
$result = $conn->query("SELECT status, COUNT(*) as count FROM email_lists GROUP BY status");

$statusCounts = [];
$total = 0;
while ($row = $result->fetch_assoc()) {
    $statusCounts[$row['status'] ?? 'NULL'] = $row['count'];
    $total += $row['count'];
}

// Show sample emails
$sample = $conn->query("SELECT id, email, name, status FROM email_lists ORDER BY id DESC LIMIT 10");

include 'includes/header.php';
?>

<style>
    .status-card {
        background: white;
        border-radius: 12px;
        padding: 1.5rem;
        box-shadow: var(--shadow-md);
        text-align: center;
        transition: transform 0.3s;
    }
    
    .status-card:hover {
        transform: translateY(-5px);
    }
    
    .status-number {
        font-size: 3rem;
        font-weight: 700;
        margin: 1rem 0;
    }
</style>

<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-chart-pie"></i>
        Email Status Overview
    </h1>
    <p class="page-subtitle">Check the current status of your email list</p>
</div>

<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="status-card" style="border-left: 4px solid var(--info-color);">
            <i class="fas fa-database fa-2x text-primary mb-3"></i>
            <div class="status-number text-primary"><?php echo number_format($total); ?></div>
            <div class="text-muted">Total Emails</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="status-card" style="border-left: 4px solid var(--warning-color);">
            <i class="fas fa-clock fa-2x" style="color: var(--warning-color);" class="mb-3"></i>
            <div class="status-number" style="color: var(--warning-color);"><?php echo number_format($statusCounts['pending'] ?? 0); ?></div>
            <div class="text-muted">Pending</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="status-card" style="border-left: 4px solid var(--success-color);">
            <i class="fas fa-check-circle fa-2x text-success mb-3"></i>
            <div class="status-number text-success"><?php echo number_format($statusCounts['sent'] ?? 0); ?></div>
            <div class="text-muted">Sent</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="status-card" style="border-left: 4px solid var(--danger-color);">
            <i class="fas fa-times-circle fa-2x text-danger mb-3"></i>
            <div class="status-number text-danger"><?php echo number_format($statusCounts['failed'] ?? 0); ?></div>
            <div class="text-muted">Failed</div>
        </div>
    </div>
</div>

<div class="card-custom mb-4">
    <div class="card-header-custom">
        <i class="fas fa-list me-2"></i>
        Recent Emails (Last 10)
    </div>
    <div class="card-body-custom p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Email</th>
                        <th>Name</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $sample->fetch_assoc()): ?>
                    <tr>
                        <td><strong><?php echo $row['id']; ?></strong></td>
                        <td><?php echo htmlspecialchars($row['email']); ?></td>
                        <td><?php echo htmlspecialchars($row['name']); ?></td>
                        <td>
                            <span class="status-badge <?php echo $row['status'] ?? 'failed'; ?>">
                                <?php echo strtoupper($row['status'] ?? 'NULL'); ?>
                            </span>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="card-custom">
    <div class="card-header-custom">
        <i class="fas fa-tools me-2"></i>
        Quick Actions
    </div>
    <div class="card-body-custom">
        <div class="row g-3">
            <div class="col-md-4">
                <a href="reset_to_pending.php" class="btn btn-outline-custom btn-custom w-100">
                    <i class="fas fa-sync"></i>
                    Reset to Pending
                </a>
            </div>
            <div class="col-md-4">
                <a href="upload.php" class="btn btn-success-custom btn-custom w-100">
                    <i class="fas fa-upload"></i>
                    Upload More
                </a>
            </div>
            <div class="col-md-4">
                <a href="list.php" class="btn btn-primary-custom btn-custom w-100">
                    <i class="fas fa-list"></i>
                    View Full List
                </a>
            </div>
        </div>
    </div>
</div>

<?php 
$conn->close();
include 'includes/footer.php'; 
?>
