<?php
session_start();
require_once 'config.php';
require_once 'PHPMailer/PHPMailer.php';
require_once 'PHPMailer/SMTP.php';
require_once 'PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Simple authentication - you can remove this or add your own
$admin_check = true; // Set to false if you want to secure this page

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Diagnostic Tool</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            padding: 30px 0;
        }
        .container {
            max-width: 900px;
        }
        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-radius: 15px;
            margin-bottom: 20px;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            padding: 20px;
        }
        .status-box {
            padding: 15px;
            border-radius: 10px;
            margin: 10px 0;
        }
        .status-success {
            background: #d4edda;
            border-left: 4px solid #28a745;
            color: #155724;
        }
        .status-error {
            background: #f8d7da;
            border-left: 4px solid #dc3545;
            color: #721c24;
        }
        .status-warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            color: #856404;
        }
        .status-info {
            background: #d1ecf1;
            border-left: 4px solid #17a2b8;
            color: #0c5460;
        }
        .config-table {
            background: white;
            border-radius: 10px;
            overflow: hidden;
        }
        .config-table td {
            padding: 12px;
            border-bottom: 1px solid #e9ecef;
        }
        .config-table tr:last-child td {
            border-bottom: none;
        }
        .btn-test {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
        }
        .btn-test:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        pre {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #dee2e6;
            max-height: 400px;
            overflow-y: auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="text-center mb-4">
            <h1><i class="fas fa-envelope-open-text text-primary"></i> Email Diagnostic Tool</h1>
            <p class="text-muted">Check your SMTP configuration and test email sending</p>
        </div>

        <?php
        $conn = getDBConnection();
        
        // Check SMTP Configuration
        echo '<div class="card">';
        echo '<div class="card-header"><h5 class="mb-0"><i class="fas fa-server me-2"></i>SMTP Configuration Status</h5></div>';
        echo '<div class="card-body">';
        
        $smtp_result = $conn->query("SELECT * FROM smtp_accounts WHERE is_default = 1 LIMIT 1");
        
        if (!$smtp_result || $smtp_result->num_rows === 0) {
            echo '<div class="status-box status-error">';
            echo '<i class="fas fa-times-circle me-2"></i><strong>ERROR:</strong> No default SMTP account configured!';
            echo '<p class="mb-0 mt-2">You need to add an SMTP account in your database.</p>';
            echo '</div>';
            
            echo '<div class="status-box status-info mt-3">';
            echo '<strong><i class="fas fa-info-circle me-2"></i>How to fix:</strong><br>';
            echo 'Add an SMTP account to your <code>smtp_accounts</code> table with <code>is_default = 1</code>';
            echo '</div>';
        } else {
            $smtp = $smtp_result->fetch_assoc();
            
            echo '<div class="status-box status-success">';
            echo '<i class="fas fa-check-circle me-2"></i><strong>SUCCESS:</strong> Default SMTP account found!';
            echo '</div>';
            
            echo '<h6 class="mt-4 mb-3"><i class="fas fa-cog me-2"></i>Current SMTP Settings:</h6>';
            echo '<table class="table config-table">';
            echo '<tr><td style="width: 200px;"><strong>SMTP Host</strong></td><td>' . htmlspecialchars($smtp['smtp_host']) . '</td></tr>';
            echo '<tr><td><strong>SMTP Port</strong></td><td>' . htmlspecialchars($smtp['smtp_port']) . '</td></tr>';
            echo '<tr><td><strong>SMTP Username</strong></td><td>' . htmlspecialchars($smtp['smtp_username']) . '</td></tr>';
            echo '<tr><td><strong>SMTP Password</strong></td><td>' . (empty($smtp['smtp_password']) ? '<span class="text-danger">NOT SET</span>' : '<span class="text-success">****** (Set)</span>') . '</td></tr>';
            echo '<tr><td><strong>Encryption</strong></td><td>' . htmlspecialchars($smtp['smtp_encryption']) . '</td></tr>';
            echo '<tr><td><strong>From Email</strong></td><td>' . htmlspecialchars($smtp['from_email']) . '</td></tr>';
            echo '<tr><td><strong>From Name</strong></td><td>' . htmlspecialchars($smtp['from_name']) . '</td></tr>';
            echo '</table>';
        }
        
        echo '</div></div>';
        
        // Test Email Form
        if ($smtp_result && $smtp_result->num_rows > 0) {
            ?>
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-paper-plane me-2"></i>Test Email Sending</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="">
                        <div class="mb-3">
                            <label class="form-label"><strong>Test Email Address:</strong></label>
                            <input type="email" name="test_email" class="form-control" placeholder="Enter email to receive test" required>
                            <small class="text-muted">We'll send a test email to this address</small>
                        </div>
                        <button type="submit" name="send_test" class="btn btn-test">
                            <i class="fas fa-paper-plane me-2"></i>Send Test Email
                        </button>
                    </form>
                    
                    <?php
                    if (isset($_POST['send_test'])) {
                        $test_email = trim($_POST['test_email']);
                        
                        echo '<div class="mt-4">';
                        echo '<h6><i class="fas fa-spinner fa-spin me-2"></i>Testing Email Send...</h6>';
                        
                        $mail = new PHPMailer(true);
                        
                        try {
                            // SMTP Configuration
                            $mail->SMTPDebug = 2; // Enable verbose debug output
                            $mail->Debugoutput = function($str, $level) {
                                echo "<div style='font-size: 12px; color: #666; margin: 2px 0;'>$str</div>";
                            };
                            
                            $mail->isSMTP();
                            $mail->Host = $smtp['smtp_host'];
                            $mail->SMTPAuth = true;
                            $mail->Username = $smtp['smtp_username'];
                            $mail->Password = $smtp['smtp_password'];
                            $mail->SMTPSecure = $smtp['smtp_encryption'];
                            $mail->Port = $smtp['smtp_port'];
                            $mail->setFrom($smtp['from_email'], $smtp['from_name']);
                            
                            // Email Content
                            $mail->addAddress($test_email);
                            $mail->isHTML(true);
                            $mail->Subject = 'Test Email from Email Sender System';
                            $mail->Body = '
                            <div style="font-family: Arial, sans-serif; padding: 20px; background: #f8f9fa;">
                                <div style="max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                                    <h2 style="color: #667eea;">✅ Test Email Successful!</h2>
                                    <p>This is a test email from your Email Sender system.</p>
                                    <p>If you received this email, your SMTP configuration is working correctly!</p>
                                    <hr style="border: 1px solid #e9ecef; margin: 20px 0;">
                                    <p style="color: #6c757d; font-size: 14px;">
                                        <strong>Sent at:</strong> ' . date('Y-m-d H:i:s') . '<br>
                                        <strong>SMTP Host:</strong> ' . htmlspecialchars($smtp['smtp_host']) . '<br>
                                        <strong>From:</strong> ' . htmlspecialchars($smtp['from_email']) . '
                                    </p>
                                </div>
                            </div>';
                            
                            $mail->AltBody = "Test Email - Your SMTP configuration is working correctly!";
                            
                            ob_start();
                            $mail->send();
                            $debug_output = ob_get_clean();
                            
                            echo '<div class="status-box status-success mt-3">';
                            echo '<i class="fas fa-check-circle me-2"></i><strong>SUCCESS!</strong> Test email sent successfully to ' . htmlspecialchars($test_email);
                            echo '</div>';
                            
                            echo '<details class="mt-3">';
                            echo '<summary style="cursor: pointer; color: #667eea; font-weight: 600;"><i class="fas fa-code me-2"></i>Show Debug Output</summary>';
                            echo '<pre class="mt-2">' . htmlspecialchars($debug_output) . '</pre>';
                            echo '</details>';
                            
                        } catch (Exception $e) {
                            echo '<div class="status-box status-error mt-3">';
                            echo '<i class="fas fa-times-circle me-2"></i><strong>ERROR:</strong> Failed to send test email!';
                            echo '<p class="mb-0 mt-2"><strong>Error Message:</strong> ' . htmlspecialchars($mail->ErrorInfo) . '</p>';
                            echo '<p class="mb-0"><strong>Exception:</strong> ' . htmlspecialchars($e->getMessage()) . '</p>';
                            echo '</div>';
                            
                            // Common error solutions
                            echo '<div class="status-box status-warning mt-3">';
                            echo '<strong><i class="fas fa-lightbulb me-2"></i>Common Solutions:</strong>';
                            echo '<ul class="mt-2 mb-0">';
                            echo '<li>Check if SMTP username and password are correct</li>';
                            echo '<li>Verify SMTP host and port are correct</li>';
                            echo '<li>Check if your email provider requires "App Password" (Gmail, Outlook, etc.)</li>';
                            echo '<li>Ensure SSL/TLS encryption matches your provider requirements</li>';
                            echo '<li>Check if firewall is blocking the SMTP port</li>';
                            echo '<li>Verify "From Email" is authorized to send from this SMTP server</li>';
                            echo '</ul>';
                            echo '</div>';
                        }
                        
                        echo '</div>';
                    }
                    ?>
                </div>
            </div>
            <?php
        }
        
        // Common SMTP Providers Guide
        ?>
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-book me-2"></i>Common SMTP Provider Settings</h5>
            </div>
            <div class="card-body">
                <div class="accordion" id="smtpProviders">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#gmail">
                                <i class="fab fa-google me-2"></i> Gmail / Google Workspace
                            </button>
                        </h2>
                        <div id="gmail" class="accordion-collapse collapse" data-bs-parent="#smtpProviders">
                            <div class="accordion-body">
                                <table class="table table-sm">
                                    <tr><td><strong>SMTP Host:</strong></td><td>smtp.gmail.com</td></tr>
                                    <tr><td><strong>Port:</strong></td><td>587 (TLS) or 465 (SSL)</td></tr>
                                    <tr><td><strong>Encryption:</strong></td><td>tls or ssl</td></tr>
                                    <tr><td><strong>Username:</strong></td><td>your-email@gmail.com</td></tr>
                                    <tr><td><strong>Password:</strong></td><td>App Password (not regular password)</td></tr>
                                </table>
                                <div class="alert alert-warning mb-0">
                                    <strong>Important:</strong> Gmail requires an "App Password" - not your regular password. 
                                    <a href="https://support.google.com/accounts/answer/185833" target="_blank">Generate one here</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#outlook">
                                <i class="fab fa-microsoft me-2"></i> Outlook / Office 365
                            </button>
                        </h2>
                        <div id="outlook" class="accordion-collapse collapse" data-bs-parent="#smtpProviders">
                            <div class="accordion-body">
                                <table class="table table-sm">
                                    <tr><td><strong>SMTP Host:</strong></td><td>smtp.office365.com</td></tr>
                                    <tr><td><strong>Port:</strong></td><td>587</td></tr>
                                    <tr><td><strong>Encryption:</strong></td><td>tls</td></tr>
                                    <tr><td><strong>Username:</strong></td><td>your-email@outlook.com</td></tr>
                                    <tr><td><strong>Password:</strong></td><td>Your account password</td></tr>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sendgrid">
                                <i class="fas fa-paper-plane me-2"></i> SendGrid
                            </button>
                        </h2>
                        <div id="sendgrid" class="accordion-collapse collapse" data-bs-parent="#smtpProviders">
                            <div class="accordion-body">
                                <table class="table table-sm">
                                    <tr><td><strong>SMTP Host:</strong></td><td>smtp.sendgrid.net</td></tr>
                                    <tr><td><strong>Port:</strong></td><td>587 or 465</td></tr>
                                    <tr><td><strong>Encryption:</strong></td><td>tls or ssl</td></tr>
                                    <tr><td><strong>Username:</strong></td><td>apikey</td></tr>
                                    <tr><td><strong>Password:</strong></td><td>Your SendGrid API Key</td></tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php
        // Check recent users without emails
        $recent_users = $conn->query("SELECT username, email, full_name, license_key, activated_date FROM users ORDER BY id DESC LIMIT 5");
        
        if ($recent_users && $recent_users->num_rows > 0) {
            echo '<div class="card">';
            echo '<div class="card-header"><h5 class="mb-0"><i class="fas fa-users me-2"></i>Recent Registrations</h5></div>';
            echo '<div class="card-body">';
            echo '<p class="text-muted">Last 5 registered users (who may need welcome emails):</p>';
            echo '<div class="table-responsive">';
            echo '<table class="table table-hover">';
            echo '<thead><tr><th>Username</th><th>Email</th><th>Registered</th><th>Action</th></tr></thead>';
            echo '<tbody>';
            
            while ($user = $recent_users->fetch_assoc()) {
                echo '<tr>';
                echo '<td>' . htmlspecialchars($user['username']) . '</td>';
                echo '<td>' . htmlspecialchars($user['email']) . '</td>';
                echo '<td>' . date('M j, Y H:i', strtotime($user['activated_date'])) . '</td>';
                echo '<td><button class="btn btn-sm btn-primary" onclick="resendEmail(\'' . htmlspecialchars($user['email']) . '\')">Resend Welcome Email</button></td>';
                echo '</tr>';
            }
            
            echo '</tbody></table>';
            echo '</div>';
            echo '</div></div>';
        }
        
        $conn->close();
        ?>
        
        <div class="text-center mt-4">
            <a href="index.php" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Dashboard
            </a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function resendEmail(email) {
            alert('Feature coming soon! Email: ' + email);
            // You can implement this to resend welcome emails to users who didn't receive them
        }
    </script>
</body>
</html>