<?php
// Protect all pages that include this header
require_once __DIR__ . '/../auth_check.php';

// Get user's license information from database
require_once __DIR__ . '/../config.php';
$conn = getDBConnection();

$user_info = null;
$stmt = $conn->prepare("
    SELECT 
        u.username,
        u.email,
        u.full_name,
        u.role,
        u.license_key,
        l.status as license_status,
        l.expires_date,
        l.created_date as license_created,
        DATEDIFF(l.expires_date, NOW()) as days_remaining
    FROM users u
    LEFT JOIN license_keys l ON u.license_key = l.license_key
    WHERE u.id = ?
");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$user_info = $stmt->get_result()->fetch_assoc();
$stmt->close();
$conn->close();

// Update session with latest data
if ($user_info) {
    $_SESSION['username'] = $user_info['username'];
    $_SESSION['full_name'] = $user_info['full_name'];
    $_SESSION['role'] = $user_info['role'];
    $_SESSION['admin_username'] = $user_info['username']; // For compatibility
}

// Determine license badge
$license_badge = '';
$license_text = '';
if ($user_info) {
    if ($user_info['expires_date'] === null) {
        $license_badge = '<span class="badge bg-success ms-2">Lifetime</span>';
        $license_text = 'Lifetime';
    } elseif ($user_info['days_remaining'] > 30) {
        $license_badge = '<span class="badge bg-success ms-2">' . $user_info['days_remaining'] . ' days</span>';
        $license_text = date('M j, Y', strtotime($user_info['expires_date']));
    } elseif ($user_info['days_remaining'] > 7) {
        $license_badge = '<span class="badge bg-warning ms-2">' . $user_info['days_remaining'] . ' days left</span>';
        $license_text = date('M j, Y', strtotime($user_info['expires_date']));
    } elseif ($user_info['days_remaining'] > 0) {
        $license_badge = '<span class="badge bg-danger ms-2">' . $user_info['days_remaining'] . ' days!</span>';
        $license_text = date('M j, Y', strtotime($user_info['expires_date']));
    } else {
        $license_badge = '<span class="badge bg-dark ms-2">Expired</span>';
        $license_text = 'Expired';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' : ''; ?>Email Sender</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome 6 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #4f46e5;
            --primary-dark: #4338ca;
            --primary-light: #6366f1;
            --success-color: #10b981;
            --danger-color: #ef4444;
            --warning-color: #f59e0b;
            --info-color: #3b82f6;
            --dark-color: #1f2937;
            --light-bg: #f9fafb;
            --border-color: #e5e7eb;
            --text-muted: #6b7280;
            --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
        }
        
        * {
            font-family: 'Inter', sans-serif;
        }
        
        body {
            background: var(--light-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background: white;
            box-shadow: var(--shadow-sm);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .navbar-brand-custom {
            font-size: 1.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .navbar-brand-custom i {
            -webkit-text-fill-color: var(--primary-color);
        }
        
        .nav-link-custom {
            color: var(--dark-color);
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .nav-link-custom:hover {
            background: var(--light-bg);
            color: var(--primary-color);
        }
        
        .nav-link-custom.active {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            color: white;
        }
        
        /* Main Content Area */
        .main-content {
            flex: 1;
            padding: 2rem 0;
        }
        
        .page-header {
            margin-bottom: 2rem;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: var(--dark-color);
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .page-subtitle {
            color: var(--text-muted);
            font-size: 1rem;
        }
        
        /* Card Styles */
        .card-custom {
            background: white;
            border-radius: 12px;
            box-shadow: var(--shadow-md);
            border: none;
            overflow: hidden;
        }
        
        .card-header-custom {
            background: white;
            border-bottom: 1px solid var(--border-color);
            padding: 1.5rem;
            font-weight: 600;
            color: var(--dark-color);
        }
        
        .card-body-custom {
            padding: 1.5rem;
        }
        
        /* Button Styles */
        .btn-custom {
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s;
            border: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            color: white;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
            color: white;
        }
        
        .btn-success-custom {
            background: linear-gradient(135deg, var(--success-color) 0%, #059669 100%);
            color: white;
        }
        
        .btn-success-custom:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
            color: white;
        }
        
        .btn-outline-custom {
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
            background: transparent;
        }
        
        .btn-outline-custom:hover {
            background: var(--primary-color);
            color: white;
            transform: translateY(-2px);
        }
        
        /* Alert Styles */
        .alert-custom {
            border-radius: 8px;
            border: none;
            padding: 1rem 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .alert-success-custom {
            background: #d1fae5;
            color: #065f46;
            border-left: 4px solid var(--success-color);
        }
        
        .alert-danger-custom {
            background: #fee2e2;
            color: #991b1b;
            border-left: 4px solid var(--danger-color);
        }
        
        .alert-warning-custom {
            background: #fef3c7;
            color: #92400e;
            border-left: 4px solid var(--warning-color);
        }
        
        .alert-info-custom {
            background: #dbeafe;
            color: #1e40af;
            border-left: 4px solid var(--info-color);
        }
        
        /* Form Styles */
        .form-label-custom {
            font-weight: 600;
            color: var(--dark-color);
            margin-bottom: 0.5rem;
        }
        
        .form-control-custom {
            border: 1px solid var(--border-color);
            border-radius: 8px;
            padding: 0.75rem;
            transition: all 0.3s;
        }
        
        .form-control-custom:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
        }
        
        /* License Info Dropdown */
        .user-dropdown {
            position: relative;
            cursor: pointer;
        }
        
        .user-dropdown-menu {
            position: absolute;
            right: 0;
            top: 100%;
            margin-top: 0.5rem;
            background: white;
            border-radius: 12px;
            box-shadow: var(--shadow-xl);
            min-width: 300px;
            padding: 1rem;
            display: none;
            z-index: 1000;
            animation: fadeIn 0.2s ease-in;
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .user-dropdown.active .user-dropdown-menu {
            display: block;
        }
        
        /* Desktop: Show on hover */
        @media (min-width: 769px) {
            .user-dropdown:hover .user-dropdown-menu {
                display: block;
            }
        }
        
        .license-info-box {
            background: var(--light-bg);
            border-radius: 8px;
            padding: 0.75rem;
            margin-top: 0.5rem;
        }
        
        .license-key-display {
            font-family: 'Courier New', monospace;
            font-size: 0.75rem;
            background: white;
            padding: 0.5rem;
            border-radius: 6px;
            word-break: break-all;
            color: var(--primary-color);
            font-weight: 600;
        }
        
        .license-info-row {
            display: flex;
            justify-content: space-between;
            padding: 0.25rem 0;
            font-size: 0.875rem;
        }
        
        .license-info-row .label {
            color: var(--text-muted);
        }
        
        .license-info-row .value {
            color: var(--dark-color);
            font-weight: 600;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .navbar-brand-custom {
                font-size: 1.25rem;
            }
            
            .page-title {
                font-size: 1.5rem;
            }
            
            .main-content {
                padding: 1rem 0;
            }
            
            .user-dropdown-menu {
                position: fixed;
                right: 1rem;
                left: 1rem;
                width: auto;
            }
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-custom">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom" href="index.php">
                <i class="fas fa-envelope"></i>
                Email Sender
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>" href="index.php">
                            <i class="fas fa-home"></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom <?php echo basename($_SERVER['PHP_SELF']) == 'upload.php' ? 'active' : ''; ?>" href="upload.php">
                            <i class="fas fa-upload"></i>
                            Upload
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom <?php echo basename($_SERVER['PHP_SELF']) == 'compose.php' ? 'active' : ''; ?>" href="compose.php">
                            <i class="fas fa-edit"></i>
                            Compose
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom <?php echo basename($_SERVER['PHP_SELF']) == 'list.php' ? 'active' : ''; ?>" href="list.php">
                            <i class="fas fa-list"></i>
                            Email List
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom <?php echo basename($_SERVER['PHP_SELF']) == 'sender.php' ? 'active' : ''; ?>" href="sender.php">
                            <i class="fas fa-paper-plane"></i>
                            Send
                        </a>
                    </li>
                    
                    <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link nav-link-custom dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-shield"></i>
                            Admin
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="admin_panel.php">
                                <i class="fas fa-users me-2"></i> User Management
                            </a></li>
                            <li><a class="dropdown-item" href="active_sessions.php">
                                <i class="fas fa-wifi me-2"></i> Active Sessions
                            </a></li>
                        </ul>
                    </li>
                    <?php endif; ?>
                    
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="test_cron.php">
                            <i class="fas fa-terminal"></i>
                            Test Cron
                        </a>
                    </li>
                    <li class="nav-item ms-lg-3">
                        <a class="nav-link nav-link-custom" href="logout.php" style="background: #fee2e2; color: #991b1b;">
                            <i class="fas fa-sign-out-alt"></i>
                            Logout
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <!-- User Info Bar with License Info -->
    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 8px 0; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <small class="user-dropdown" style="cursor: pointer;">
                    <i class="fas fa-user-shield me-1"></i>
                    Logged in as: <strong><?php echo htmlspecialchars($user_info['username'] ?? 'User'); ?></strong>
                    <?php echo $license_badge; ?>
                    <i class="fas fa-chevron-down ms-1"></i>
                    
                    <!-- License Info Dropdown -->
                    <div class="user-dropdown-menu">
                        <div style="font-weight: 600; color: var(--dark-color); margin-bottom: 0.5rem;">
                            <?php echo htmlspecialchars($user_info['full_name'] ?? 'User'); ?>
                        </div>
                        <div style="font-size: 0.875rem; color: var(--text-muted); margin-bottom: 1rem;">
                            <?php echo htmlspecialchars($user_info['email'] ?? ''); ?>
                        </div>
                        
                        <?php if ($user_info): ?>
                        <div class="license-info-box">
                            <div style="font-size: 0.75rem; color: var(--text-muted); font-weight: 600; margin-bottom: 0.5rem;">
                                <i class="fas fa-key me-1"></i> LICENSE KEY
                            </div>
                            <div class="license-key-display">
                                <?php echo htmlspecialchars($user_info['license_key']); ?>
                            </div>
                            
                            <div style="margin-top: 0.75rem;">
                                <div class="license-info-row">
                                    <span class="label">Status:</span>
                                    <span class="value"><?php echo $user_info['license_status'] === 'used' ? '✓ Active' : 'Pending'; ?></span>
                                </div>
                                <div class="license-info-row">
                                    <span class="label">Expires:</span>
                                    <span class="value"><?php echo $license_text; ?></span>
                                </div>
                                
                                <?php if ($user_info['expires_date'] && $user_info['days_remaining'] <= 30 && $user_info['days_remaining'] > 0): ?>
                                <div class="alert alert-warning mt-2 mb-0 p-2" style="font-size: 0.75rem;">
                                    <i class="fas fa-exclamation-triangle me-1"></i>
                                    License expires in <?php echo $user_info['days_remaining']; ?> days!
                                </div>
                                <?php elseif ($user_info['days_remaining'] <= 0): ?>
                                <div class="alert alert-danger mt-2 mb-0 p-2" style="font-size: 0.75rem;">
                                    <i class="fas fa-times-circle me-1"></i>
                                    License has expired!
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </small>
                <small>
                    <i class="fas fa-clock me-1"></i>
                    <?php echo date('l, F j, Y - g:i A'); ?>
                </small>
            </div>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <div class="container">