<?php
session_start();
require_once 'config.php';

$page_title = 'Dashboard';

$conn = getDBConnection();
$stats = ['total' => 0, 'pending' => 0, 'sent' => 0, 'failed' => 0];
$result = $conn->query("SELECT COUNT(*) as total, SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending, SUM(CASE WHEN status = 'sent' THEN 1 ELSE 0 END) as sent, SUM(CASE WHEN status = 'failed' THEN 1 ELSE 0 END) as failed FROM email_lists");
if ($result && $row = $result->fetch_assoc()) { $stats = $row; }
$conn->close();

include 'includes/header.php';
?>

<style>
    .stat-card {
        background: white;
        border-radius: 12px;
        padding: 1.5rem;
        box-shadow: var(--shadow-md);
        transition: transform 0.3s, box-shadow 0.3s;
        border-left: 4px solid;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: var(--shadow-xl);
    }
    
    .stat-card.total {
        border-left-color: var(--info-color);
    }
    
    .stat-card.pending {
        border-left-color: var(--warning-color);
    }
    
    .stat-card.sent {
        border-left-color: var(--success-color);
    }
    
    .stat-card.failed {
        border-left-color: var(--danger-color);
    }
    
    .stat-icon {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        margin-bottom: 1rem;
    }
    
    .stat-icon.total {
        background: rgba(59, 130, 246, 0.1);
        color: var(--info-color);
    }
    
    .stat-icon.pending {
        background: rgba(245, 158, 11, 0.1);
        color: var(--warning-color);
    }
    
    .stat-icon.sent {
        background: rgba(16, 185, 129, 0.1);
        color: var(--success-color);
    }
    
    .stat-icon.failed {
        background: rgba(239, 68, 68, 0.1);
        color: var(--danger-color);
    }
    
    .stat-number {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 0.25rem;
    }
    
    .stat-label {
        color: var(--text-muted);
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        font-weight: 600;
    }
    
    .menu-card {
        background: white;
        border-radius: 12px;
        padding: 2rem;
        box-shadow: var(--shadow-md);
        transition: all 0.3s;
        text-decoration: none;
        color: inherit;
        display: block;
        border: 2px solid transparent;
    }
    
    .menu-card:hover {
        transform: translateY(-5px);
        box-shadow: var(--shadow-xl);
        border-color: var(--primary-color);
    }
    
    .menu-icon {
        width: 70px;
        height: 70px;
        border-radius: 16px;
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        color: white;
        margin-bottom: 1.5rem;
    }
    
    .menu-title {
        font-size: 1.25rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        color: var(--dark-color);
    }
    
    .menu-description {
        color: var(--text-muted);
        font-size: 0.875rem;
        margin-bottom: 0;
    }
</style>

<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-chart-line"></i>
        Dashboard
    </h1>
    <p class="page-subtitle">Welcome back! Here's an overview of your email campaigns</p>
</div>

<!-- Statistics Cards -->
<div class="row g-4 mb-4">
    <div class="col-lg-3 col-md-6">
        <div class="stat-card total">
            <div class="stat-icon total">
                <i class="fas fa-database"></i>
            </div>
            <div class="stat-number"><?php echo number_format($stats['total']); ?></div>
            <div class="stat-label">Total Emails</div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <div class="stat-card pending">
            <div class="stat-icon pending">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-number"><?php echo number_format($stats['pending']); ?></div>
            <div class="stat-label">Pending</div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <div class="stat-card sent">
            <div class="stat-icon sent">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-number"><?php echo number_format($stats['sent']); ?></div>
            <div class="stat-label">Sent</div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <div class="stat-card failed">
            <div class="stat-icon failed">
                <i class="fas fa-times-circle"></i>
            </div>
            <div class="stat-number"><?php echo number_format($stats['failed']); ?></div>
            <div class="stat-label">Failed</div>
        </div>
    </div>
</div>

<!-- Info Alert -->
<div class="alert alert-custom alert-info-custom alert-dismissible fade show" role="alert">
    <i class="fas fa-info-circle fa-lg"></i>
    <div>
        <strong>Batch Sending Configuration:</strong>
        Emails are sent in batches of <strong><?php echo BATCH_SIZE; ?></strong> every <strong><?php echo BATCH_INTERVAL/60; ?> minutes</strong>.
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>

<!-- Quick Actions -->
<div class="row g-4">
    <div class="col-lg-3 col-md-6">
        <a href="upload.php" class="menu-card">
            <div class="menu-icon">
                <i class="fas fa-upload"></i>
            </div>
            <h3 class="menu-title">Upload Email List</h3>
            <p class="menu-description">Import email addresses from CSV file</p>
        </a>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <a href="compose.php" class="menu-card">
            <div class="menu-icon">
                <i class="fas fa-edit"></i>
            </div>
            <h3 class="menu-title">Compose Email</h3>
            <p class="menu-description">Create and design your email campaign</p>
        </a>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <a href="list.php" class="menu-card">
            <div class="menu-icon">
                <i class="fas fa-list"></i>
            </div>
            <h3 class="menu-title">View Email List</h3>
            <p class="menu-description">Manage your email recipients</p>
        </a>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <a href="sender.php" class="menu-card">
            <div class="menu-icon">
                <i class="fas fa-paper-plane"></i>
            </div>
            <h3 class="menu-title">Start Sending</h3>
            <p class="menu-description">Begin batch email sending process</p>
        </a>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
