<?php
session_start();
require_once 'config.php';

$page_title = 'Email List';

$conn = getDBConnection();

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 50;
$offset = ($page - 1) * $per_page;

// Get total count
$total_result = $conn->query("SELECT COUNT(*) as total FROM email_lists");
$total_row = $total_result->fetch_assoc();
$total_emails = $total_row['total'];
$total_pages = ceil($total_emails / $per_page);

// Get emails with pagination
$result = $conn->query("SELECT * FROM email_lists ORDER BY added_date DESC LIMIT $per_page OFFSET $offset");

include 'includes/header.php';
?>

<style>
    .filter-bar {
        background: white;
        padding: 1.5rem;
        border-radius: 12px;
        box-shadow: var(--shadow-md);
        margin-bottom: 1.5rem;
    }
    
    .filter-btn {
        padding: 0.5rem 1rem;
        border: 2px solid var(--border-color);
        background: white;
        border-radius: 8px;
        transition: all 0.3s;
        cursor: pointer;
    }
    
    .filter-btn.active,
    .filter-btn:hover {
        border-color: var(--primary-color);
        background: rgba(79, 70, 229, 0.1);
        color: var(--primary-color);
    }
    
    .table-responsive-custom {
        background: white;
        border-radius: 12px;
        box-shadow: var(--shadow-md);
        overflow: hidden;
    }
    
    .table-custom {
        margin-bottom: 0;
    }
    
    .table-custom thead {
        background: var(--light-bg);
    }
    
    .table-custom th {
        font-weight: 600;
        color: var(--dark-color);
        padding: 1rem;
        border-bottom: 2px solid var(--border-color);
    }
    
    .table-custom td {
        padding: 1rem;
        vertical-align: middle;
    }
    
    .table-custom tbody tr {
        transition: background 0.2s;
    }
    
    .table-custom tbody tr:hover {
        background: var(--light-bg);
    }
    
    .status-badge {
        padding: 0.375rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        display: inline-block;
    }
    
    .status-badge.pending {
        background: rgba(245, 158, 11, 0.2);
        color: #92400e;
    }
    
    .status-badge.sent {
        background: rgba(16, 185, 129, 0.2);
        color: #065f46;
    }
    
    .status-badge.failed {
        background: rgba(239, 68, 68, 0.2);
        color: #991b1b;
    }
    
    .pagination-custom {
        display: flex;
        gap: 0.5rem;
        justify-content: center;
        margin-top: 1.5rem;
    }
    
    .page-link-custom {
        padding: 0.5rem 1rem;
        border: 2px solid var(--border-color);
        border-radius: 8px;
        color: var(--dark-color);
        text-decoration: none;
        transition: all 0.3s;
    }
    
    .page-link-custom:hover {
        border-color: var(--primary-color);
        color: var(--primary-color);
    }
    
    .page-link-custom.active {
        background: var(--primary-color);
        border-color: var(--primary-color);
        color: white;
    }
    
    .page-link-custom.disabled {
        opacity: 0.5;
        cursor: not-allowed;
        pointer-events: none;
    }
</style>

<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-list"></i>
        Email List
    </h1>
    <p class="page-subtitle">Manage and view your email recipients</p>
</div>

<div class="filter-bar">
    <div class="row align-items-center">
        <div class="col-md-6 mb-3 mb-md-0">
            <div class="d-flex gap-2 flex-wrap">
                <button class="filter-btn active" onclick="filterStatus('all')">
                    <i class="fas fa-list"></i> All (<?php echo number_format($total_emails); ?>)
                </button>
                <button class="filter-btn" onclick="filterStatus('pending')">
                    <i class="fas fa-clock"></i> Pending
                </button>
                <button class="filter-btn" onclick="filterStatus('sent')">
                    <i class="fas fa-check"></i> Sent
                </button>
                <button class="filter-btn" onclick="filterStatus('failed')">
                    <i class="fas fa-times"></i> Failed
                </button>
            </div>
        </div>
        <div class="col-md-6 text-md-end">
            <div class="btn-group">
                <a href="upload.php" class="btn btn-primary-custom btn-custom">
                    <i class="fas fa-upload"></i>
                    Upload More
                </a>
            </div>
        </div>
    </div>
</div>

<?php if ($result->num_rows > 0): ?>
<div class="table-responsive-custom">
    <table class="table table-custom">
        <thead>
            <tr>
                <th><i class="fas fa-hashtag me-2"></i>ID</th>
                <th><i class="fas fa-envelope me-2"></i>Email</th>
                <th><i class="fas fa-user me-2"></i>Name</th>
                <th><i class="fas fa-info-circle me-2"></i>Status</th>
                <th><i class="fas fa-calendar-plus me-2"></i>Added</th>
                <th><i class="fas fa-paper-plane me-2"></i>Sent</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><strong><?php echo $row["id"]; ?></strong></td>
                <td>
                    <i class="fas fa-at text-muted me-2"></i>
                    <?php echo htmlspecialchars($row["email"]); ?>
                </td>
                <td><?php echo htmlspecialchars($row["name"]) ?: '-'; ?></td>
                <td>
                    <span class="status-badge <?php echo $row["status"]; ?>">
                        <?php 
                        $icon = $row["status"] == 'pending' ? 'clock' : ($row["status"] == 'sent' ? 'check-circle' : 'times-circle');
                        ?>
                        <i class="fas fa-<?php echo $icon; ?> me-1"></i>
                        <?php echo strtoupper($row["status"]); ?>
                    </span>
                </td>
                <td>
                    <small class="text-muted">
                        <i class="far fa-calendar me-1"></i>
                        <?php echo date("M j, Y", strtotime($row["added_date"])); ?>
                        <br>
                        <i class="far fa-clock me-1"></i>
                        <?php echo date("g:i A", strtotime($row["added_date"])); ?>
                    </small>
                </td>
                <td>
                    <?php if ($row["sent_date"]): ?>
                        <small class="text-muted">
                            <i class="far fa-calendar me-1"></i>
                            <?php echo date("M j, Y", strtotime($row["sent_date"])); ?>
                            <br>
                            <i class="far fa-clock me-1"></i>
                            <?php echo date("g:i A", strtotime($row["sent_date"])); ?>
                        </small>
                    <?php else: ?>
                        <span class="text-muted">-</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<?php if ($total_pages > 1): ?>
<div class="pagination-custom">
    <a href="?page=1" class="page-link-custom <?php echo $page == 1 ? 'disabled' : ''; ?>">
        <i class="fas fa-angle-double-left"></i>
    </a>
    <a href="?page=<?php echo max(1, $page - 1); ?>" class="page-link-custom <?php echo $page == 1 ? 'disabled' : ''; ?>">
        <i class="fas fa-angle-left"></i>
    </a>
    
    <?php
    $start = max(1, $page - 2);
    $end = min($total_pages, $page + 2);
    
    for ($i = $start; $i <= $end; $i++):
    ?>
        <a href="?page=<?php echo $i; ?>" class="page-link-custom <?php echo $page == $i ? 'active' : ''; ?>">
            <?php echo $i; ?>
        </a>
    <?php endfor; ?>
    
    <a href="?page=<?php echo min($total_pages, $page + 1); ?>" class="page-link-custom <?php echo $page == $total_pages ? 'disabled' : ''; ?>">
        <i class="fas fa-angle-right"></i>
    </a>
    <a href="?page=<?php echo $total_pages; ?>" class="page-link-custom <?php echo $page == $total_pages ? 'disabled' : ''; ?>">
        <i class="fas fa-angle-double-right"></i>
    </a>
</div>

<div class="text-center mt-3 text-muted">
    <small>
        Showing <?php echo $offset + 1; ?> to <?php echo min($offset + $per_page, $total_emails); ?> of <?php echo number_format($total_emails); ?> emails
    </small>
</div>
<?php endif; ?>

<?php else: ?>
<div class="card-custom text-center py-5">
    <div class="py-5">
        <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
        <h3>No Emails Found</h3>
        <p class="text-muted">Start by uploading your email list</p>
        <a href="upload.php" class="btn btn-primary-custom btn-custom mt-3">
            <i class="fas fa-upload"></i>
            Upload Email List
        </a>
    </div>
</div>
<?php endif; ?>

<script>
function filterStatus(status) {
    // This would typically use AJAX to filter without page reload
    // For now, it's a placeholder for future implementation
    alert('Filter by: ' + status + '\nThis feature can be enhanced with AJAX filtering.');
}
</script>

<?php 
$conn->close();
include 'includes/footer.php'; 
?>
