<?php
session_start();
require_once 'config.php';

$page_title = 'Reset Email Status';

if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
    $conn = getDBConnection();
    
    // Reset all emails to pending
    $result = $conn->query("UPDATE email_lists SET status = 'pending', sent_date = NULL, error_message = NULL");
    
    if ($result) {
        $affected = $conn->affected_rows;
        $_SESSION['success'] = "Successfully reset $affected emails to PENDING status.";
    } else {
        $_SESSION['error'] = "Error: " . $conn->error;
    }
    
    $conn->close();
    header("Location: reset_to_pending.php");
    exit;
}

include 'includes/header.php';
?>

<style>
    .warning-card {
        background: white;
        border-radius: 20px;
        box-shadow: var(--shadow-xl);
        overflow: hidden;
        max-width: 600px;
        margin: 2rem auto;
    }
    
    .warning-header {
        background: linear-gradient(135deg, var(--warning-color) 0%, #d97706 100%);
        color: white;
        padding: 2rem;
        text-align: center;
    }
    
    .warning-icon {
        width: 80px;
        height: 80px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1rem;
    }
</style>

<?php if (isset($_SESSION['success'])): ?>
<div class="warning-card">
    <div class="card-header-gradient success-header">
        <div class="icon-circle">
            <i class="fas fa-check"></i>
        </div>
        <h2>Success!</h2>
    </div>
    <div class="card-body-custom text-center">
        <div class="alert alert-custom alert-success-custom">
            <i class="fas fa-check-circle fa-lg"></i>
            <div><?php echo htmlspecialchars($_SESSION['success']); ?></div>
        </div>
        <div class="d-flex gap-2 justify-content-center">
            <a href="sender.php" class="btn btn-success-custom btn-custom">
                <i class="fas fa-paper-plane"></i> Start Sending
            </a>
            <a href="index.php" class="btn btn-primary-custom btn-custom">
                <i class="fas fa-home"></i> Dashboard
            </a>
        </div>
    </div>
</div>
<?php unset($_SESSION['success']); ?>

<?php elseif (isset($_SESSION['error'])): ?>
<div class="warning-card">
    <div class="card-body-custom text-center">
        <div class="alert alert-custom alert-danger-custom">
            <i class="fas fa-times-circle fa-lg"></i>
            <div><?php echo htmlspecialchars($_SESSION['error']); ?></div>
        </div>
        <a href="index.php" class="btn btn-primary-custom btn-custom">
            <i class="fas fa-home"></i> Back to Dashboard
        </a>
    </div>
</div>
<?php unset($_SESSION['error']); ?>

<?php else: ?>
<div class="warning-card">
    <div class="warning-header">
        <div class="warning-icon">
            <i class="fas fa-exclamation-triangle fa-3x"></i>
        </div>
        <h2>Reset All Emails to Pending?</h2>
    </div>
    <div class="card-body-custom">
        <div class="alert alert-custom alert-warning-custom mb-4">
            <i class="fas fa-exclamation-triangle fa-lg"></i>
            <div>
                <strong>Warning:</strong> This action will reset ALL emails in your database to "pending" status, 
                including previously sent emails. They will be sent again when you run the sender.
            </div>
        </div>
        
        <div class="text-center">
            <p class="mb-4">Are you sure you want to continue?</p>
            <div class="d-flex gap-2 justify-content-center">
                <a href="reset_to_pending.php?confirm=yes" class="btn btn-custom" style="background: var(--danger-color); color: white;">
                    <i class="fas fa-check"></i> Yes, Reset All
                </a>
                <a href="check_status.php" class="btn btn-outline-custom btn-custom">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php include 'includes/footer.php'; ?>
