<?php
session_start();
require_once 'config.php';
require_once 'PHPMailer/PHPMailer.php';
require_once 'PHPMailer/SMTP.php';
require_once 'PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// If already logged in, redirect to dashboard
if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

$error = '';
$success = '';

// Function to send welcome email
function sendWelcomeEmail($to_email, $to_name, $username, $license_key, $expires_date) {
    try {
        $conn = getDBConnection();
        
        // Get system SMTP settings
        $smtp_result = $conn->query("SELECT * FROM smtp_accounts WHERE is_default = 1 LIMIT 1");
        
        if (!$smtp_result || $smtp_result->num_rows === 0) {
            $conn->close();
            error_log("No default SMTP account configured");
            return false; // No SMTP configured
        }
        
        $smtp = $smtp_result->fetch_assoc();
        $conn->close();
        
        $mail = new PHPMailer(true);
        
        // SMTP Configuration
        $mail->isSMTP();
        $mail->Host = $smtp['smtp_host'];
        $mail->SMTPAuth = true;
        $mail->Username = $smtp['smtp_username'];
        $mail->Password = $smtp['smtp_password'];
        $mail->SMTPSecure = $smtp['smtp_encryption'];
        $mail->Port = $smtp['smtp_port'];
        $mail->setFrom($smtp['from_email'], $smtp['from_name']);
        
        // Email Content
        $mail->addAddress($to_email, $to_name);
        $mail->isHTML(true);
        $mail->Subject = 'Welcome to Email Sender - Account Activated!';
        
        // Expiry text
        $expiry_text = $expires_date ? date('F j, Y', strtotime($expires_date)) : 'Lifetime';
        
        $mail->Body = '
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9fafb; padding: 30px; border-radius: 0 0 10px 10px; }
        .welcome-box { background: white; padding: 20px; border-radius: 10px; margin: 20px 0; border-left: 4px solid #667eea; }
        .credentials { background: #e0e7ff; padding: 15px; border-radius: 8px; margin: 15px 0; }
        .credential-item { margin: 10px 0; }
        .credential-label { font-weight: 600; color: #4338ca; }
        .credential-value { font-family: monospace; background: white; padding: 5px 10px; border-radius: 4px; display: inline-block; }
        .button { background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; display: inline-block; margin: 20px 0; }
        .footer { text-align: center; color: #6b7280; font-size: 14px; margin-top: 30px; }
        .feature-list { background: white; padding: 20px; border-radius: 10px; margin: 20px 0; }
        .feature-item { padding: 10px 0; border-bottom: 1px solid #e5e7eb; }
        .feature-item:last-child { border-bottom: none; }
        .feature-icon { color: #10b981; margin-right: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎉 Welcome to Email Sender!</h1>
            <p>Your account has been successfully activated</p>
        </div>
        
        <div class="content">
            <div class="welcome-box">
                <h2>Hello ' . htmlspecialchars($to_name) . '!</h2>
                <p>Thank you for joining Email Sender. Your account is now active and ready to use.</p>
            </div>
            
            <h3>📋 Your Account Details:</h3>
            <div class="credentials">
                <div class="credential-item">
                    <span class="credential-label">Username:</span>
                    <span class="credential-value">' . htmlspecialchars($username) . '</span>
                </div>
                <div class="credential-item">
                    <span class="credential-label">Email:</span>
                    <span class="credential-value">' . htmlspecialchars($to_email) . '</span>
                </div>
                <div class="credential-item">
                    <span class="credential-label">License Key:</span>
                    <span class="credential-value">' . htmlspecialchars($license_key) . '</span>
                </div>
                <div class="credential-item">
                    <span class="credential-label">License Expires:</span>
                    <span class="credential-value">' . $expiry_text . '</span>
                </div>
            </div>
            
            <h3>✨ What You Can Do:</h3>
            <div class="feature-list">
                <div class="feature-item">
                    <span class="feature-icon">✓</span> Upload email lists (CSV, TXT)
                </div>
                <div class="feature-item">
                    <span class="feature-icon">✓</span> Compose beautiful HTML emails
                </div>
                <div class="feature-item">
                    <span class="feature-icon">✓</span> Send bulk emails efficiently
                </div>
                <div class="feature-item">
                    <span class="feature-icon">✓</span> Use your own SMTP credentials
                </div>
                <div class="feature-item">
                    <span class="feature-icon">✓</span> Track sending progress
                </div>
                <div class="feature-item">
                    <span class="feature-icon">✓</span> Schedule email campaigns
                </div>
            </div>
            
            <div style="text-align: center;">
                <a href="https://usgovdonation.com/email_sender/login.php" class="button">Login to Your Account</a>
            </div>
            
            <div style="background: #fef3c7; padding: 15px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #f59e0b;">
                <strong>⚡ Quick Tip:</strong> Add your own SMTP credentials in Settings to start sending emails immediately!
            </div>
            
            <div class="footer">
                <p>Need help? Contact your administrator or check our documentation.</p>
                <p style="color: #9ca3af; font-size: 12px;">
                    This is an automated message. Please do not reply to this email.
                </p>
            </div>
        </div>
    </div>
</body>
</html>';
        
        $mail->AltBody = "Welcome to Email Sender!\n\nYour account has been activated.\n\nUsername: $username\nEmail: $to_email\nLicense Key: $license_key\nExpires: $expiry_text\n\nLogin at: https://usgovdonation.com/email_sender/login.php";
        
        $mail->send();
        return true;
        
    } catch (Exception $e) {
        error_log("Welcome email failed for $to_email: " . $e->getMessage());
        if (isset($mail)) {
            error_log("PHPMailer Error: " . $mail->ErrorInfo);
        }
        return false;
    } catch (Throwable $e) {
        error_log("Critical error sending welcome email: " . $e->getMessage());
        return false;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $full_name = trim($_POST['full_name'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    $license_key = trim($_POST['license_key'] ?? '');
    
    // Validation
    if (empty($username) || empty($email) || empty($full_name) || empty($password) || empty($license_key)) {
        $error = 'All fields are required';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Invalid email address';
    } elseif (strlen($username) < 3 || strlen($username) > 50) {
        $error = 'Username must be between 3 and 50 characters';
    } elseif (strlen($password) < 6) {
        $error = 'Password must be at least 6 characters';
    } elseif ($password !== $confirm_password) {
        $error = 'Passwords do not match';
    } else {
        $conn = getDBConnection();
        
        // Check if username already exists
        $stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        if ($stmt->get_result()->num_rows > 0) {
            $error = 'Username already taken';
        }
        $stmt->close();
        
        // Check if email already exists
        if (empty($error)) {
            $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
            $stmt->bind_param("s", $email);
            $stmt->execute();
            if ($stmt->get_result()->num_rows > 0) {
                $error = 'Email already registered';
            }
            $stmt->close();
        }
        
        // Verify license key
        if (empty($error)) {
            $stmt = $conn->prepare("SELECT id, status, expires_date, max_users FROM license_keys WHERE license_key = ?");
            $stmt->bind_param("s", $license_key);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows === 0) {
                $error = 'Invalid license key';
            } else {
                $license = $result->fetch_assoc();
                
                if ($license['status'] !== 'available') {
                    $error = 'This license key has already been used or is no longer valid';
                } elseif ($license['expires_date'] && strtotime($license['expires_date']) < time()) {
                    $error = 'This license key has expired';
                } else {
                    // Check if license has reached max users
                    $stmt2 = $conn->prepare("SELECT COUNT(*) as count FROM users WHERE license_key = ?");
                    $stmt2->bind_param("s", $license_key);
                    $stmt2->execute();
                    $count_result = $stmt2->get_result()->fetch_assoc();
                    
                    if ($count_result['count'] >= $license['max_users']) {
                        $error = 'This license key has reached its maximum number of users';
                    }
                    $stmt2->close();
                }
            }
            $stmt->close();
        }
        
        // Create user account
        if (empty($error)) {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            $stmt = $conn->prepare("INSERT INTO users (username, email, full_name, password, license_key, status, activated_date) VALUES (?, ?, ?, ?, ?, 'active', NOW())");
            $stmt->bind_param("sssss", $username, $email, $full_name, $hashed_password, $license_key);
            
            if ($stmt->execute()) {
                $user_id = $stmt->insert_id;
                
                // Update license key status
                $stmt2 = $conn->prepare("UPDATE license_keys SET status = 'used', used_date = NOW(), used_by_user_id = ? WHERE license_key = ?");
                $stmt2->bind_param("is", $user_id, $license_key);
                $stmt2->execute();
                $stmt2->close();
                
                // Send welcome email - wrapped in try-catch to prevent crashes
                try {
                    $email_sent = sendWelcomeEmail($email, $full_name, $username, $license_key, $license['expires_date']);
                    
                    if ($email_sent) {
                        $success = 'Account created successfully! A welcome email has been sent to ' . htmlspecialchars($email) . '. You can now login.';
                    } else {
                        $success = 'Account created successfully! You can now login. (Welcome email could not be sent)';
                    }
                } catch (Exception $e) {
                    error_log("Exception while sending welcome email: " . $e->getMessage());
                    $success = 'Account created successfully! You can now login.';
                }
                
                // Auto-redirect to login after 3 seconds
                header("refresh:3;url=login.php");
            } else {
                $error = 'Registration failed. Please try again.';
            }
            $stmt->close();
        }
        
        $conn->close();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign Up - Email Sender</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .signup-container {
            width: 100%;
            max-width: 500px;
        }
        
        .signup-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
            backdrop-filter: blur(10px);
        }
        
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
        }
        
        .card-header h1 {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .card-header p {
            opacity: 0.9;
            font-size: 15px;
        }
        
        .card-body {
            padding: 40px 30px;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            padding: 15px 20px;
            margin-bottom: 25px;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert-danger {
            background: #fee;
            color: #c33;
        }
        
        .alert-success {
            background: #efe;
            color: #383;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-label {
            display: block;
            font-weight: 600;
            color: #374151;
            margin-bottom: 8px;
            font-size: 14px;
        }
        
        .input-group {
            position: relative;
            display: flex;
            align-items: center;
        }
        
        .input-group i:first-child {
            position: absolute;
            left: 15px;
            color: #9ca3af;
            z-index: 1;
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px 12px 45px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 15px;
            transition: all 0.3s ease;
            font-family: 'Inter', sans-serif;
        }
        
        .form-control:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
        }
        
        .toggle-password {
            position: absolute;
            right: 15px;
            color: #9ca3af;
            cursor: pointer;
            z-index: 1;
        }
        
        .toggle-password:hover {
            color: #667eea;
        }
        
        .text-muted {
            color: #6b7280;
            font-size: 13px;
            margin-top: 5px;
            display: block;
        }
        
        .license-info {
            background: #f0f9ff;
            padding: 12px 15px;
            border-radius: 8px;
            margin-top: 10px;
            font-size: 13px;
            color: #0369a1;
            border-left: 3px solid #0ea5e9;
        }
        
        .btn-signup {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
        }
        
        .btn-signup:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
        }
        
        .footer-text {
            text-align: center;
            margin-top: 25px;
            color: #6b7280;
            font-size: 14px;
        }
        
        .footer-text a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        
        .footer-text a:hover {
            text-decoration: underline;
        }
        
        @media (max-width: 576px) {
            .card-header {
                padding: 30px 20px;
            }
            
            .card-header h1 {
                font-size: 24px;
            }
            
            .card-body {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="signup-container">
        <div class="signup-card">
            <div class="card-header">
                <h1><i class="fas fa-envelope-open-text"></i> Email Sender</h1>
                <p>Create your account to get started</p>
            </div>
            
            <div class="card-body">
                <?php if ($error): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i>
                        <?php echo htmlspecialchars($error); ?>
                    </div>
                <?php endif; ?>
                
                <?php if ($success): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <?php echo $success; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" id="signupForm">
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-user me-2"></i>
                            Full Name
                        </label>
                        <div class="input-group">
                            <i class="fas fa-user"></i>
                            <input 
                                type="text" 
                                name="full_name" 
                                class="form-control" 
                                placeholder="Enter your full name" 
                                required
                                value="<?php echo htmlspecialchars($_POST['full_name'] ?? ''); ?>"
                            >
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-at me-2"></i>
                            Username
                        </label>
                        <div class="input-group">
                            <i class="fas fa-at"></i>
                            <input 
                                type="text" 
                                name="username" 
                                class="form-control" 
                                placeholder="Choose a username" 
                                required
                                minlength="3"
                                maxlength="50"
                                value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>"
                            >
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-envelope me-2"></i>
                            Email Address
                        </label>
                        <div class="input-group">
                            <i class="fas fa-envelope"></i>
                            <input 
                                type="email" 
                                name="email" 
                                class="form-control" 
                                placeholder="Enter your email" 
                                required
                                value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>"
                            >
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-lock me-2"></i>
                            Password
                        </label>
                        <div class="input-group">
                            <i class="fas fa-lock"></i>
                            <input 
                                type="password" 
                                name="password" 
                                id="password"
                                class="form-control" 
                                placeholder="Create a password" 
                                required
                                minlength="6"
                            >
                            <i class="fas fa-eye toggle-password" id="togglePassword"></i>
                        </div>
                        <small class="text-muted">Minimum 6 characters</small>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-lock me-2"></i>
                            Confirm Password
                        </label>
                        <div class="input-group">
                            <i class="fas fa-lock"></i>
                            <input 
                                type="password" 
                                name="confirm_password" 
                                id="confirm_password"
                                class="form-control" 
                                placeholder="Confirm your password" 
                                required
                            >
                            <i class="fas fa-eye toggle-password" id="toggleConfirmPassword"></i>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-key me-2"></i>
                            License Key
                        </label>
                        <div class="input-group">
                            <i class="fas fa-key"></i>
                            <input 
                                type="text" 
                                name="license_key" 
                                class="form-control" 
                                placeholder="XXXX-XXXX-XXXX-XXXX" 
                                required
                                style="text-transform: uppercase;"
                                value="<?php echo htmlspecialchars($_POST['license_key'] ?? ''); ?>"
                            >
                        </div>
                        <div class="license-info">
                            <i class="fas fa-info-circle me-1"></i>
                            <strong>Don't have a license key?</strong> Contact your administrator to get one.
                        </div>
                    </div>
                    
                    <button type="submit" class="btn-signup">
                        <i class="fas fa-user-plus me-2"></i>
                        Create Account
                    </button>
                </form>
                
                <div class="footer-text">
                    Already have an account? <a href="login.php">Login here</a>
                </div>
            </div>
        </div>
        
        <div class="text-center mt-4">
            <small style="color: rgba(255,255,255,0.8);">
                <i class="fas fa-shield-alt me-1"></i>
                Your data is secure and encrypted
            </small>
        </div>
    </div>
    
    <script>
        // Toggle password visibility
        const togglePassword = document.getElementById('togglePassword');
        const password = document.getElementById('password');
        
        togglePassword.addEventListener('click', function() {
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash'); 
        });
        
        const toggleConfirmPassword = document.getElementById('toggleConfirmPassword');
        const confirmPassword = document.getElementById('confirm_password');
        
        toggleConfirmPassword.addEventListener('click', function() {
            const type = confirmPassword.getAttribute('type') === 'password' ? 'text' : 'password';
            confirmPassword.setAttribute('type', type);
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash'); 
        });
        
        // Password match validation
        const form = document.getElementById('signupForm');
        form.addEventListener('submit', function(e) {
            if (password.value !== confirmPassword.value) {
                e.preventDefault();
                alert('Passwords do not match!');
                confirmPassword.focus();
            }
        });
        
        // Auto uppercase license key
        const licenseInput = document.querySelector('input[name="license_key"]');
        licenseInput.addEventListener('input', function() {
            this.value = this.value.toUpperCase();
        });
    </script>
</body>
</html>